﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

using OpenAPI_App_Manager.Properties;

namespace OpenAPI_App_Manager.Components.MFPDetails
{
    public partial class OptionState : UserControl
    {
        private CheckState state;
        public CheckState State
        {
            get
            {
                return state;
            }
            set
            {
                state = value;
                switch (value)
                {
                    case CheckState.Checked: pictureBoxState.Image = Resources.Mark_Tick_18; break;
                    case CheckState.Indeterminate: pictureBoxState.Image = Resources.Minus; break;
                    case CheckState.Unchecked: pictureBoxState.Image = Resources.Mark_Cross_18; break;
                }
            }
        }
        public bool? Checked
        {
            set
            {
                switch (value)
                {
                    case true: State = CheckState.Checked; break;
                    case false: State = CheckState.Unchecked; break;
                    case null: State = CheckState.Indeterminate; break;
                }
            }
        }

        public string OptionName
        {
            get
            {
                return labelName.Text;
            }
            set
            {
                labelName.Text = value;
            }
        }


        public OptionState()
        {
            InitializeComponent();
        }
    }
}
